//
//  Grassy Knoll
//  (c) 2005 Signwave UK
//  http://www.signwave.co.uk/
//
//  If you use this to generate some awesome visuals, please let us know!
//  mail@signwave.co.uk
//  
//  2006-10-12 modified by Hiroto Tsubaki (tg@tres-graficos.jp)
//    added some parameters (unit radius/underground disabled/height/thickness/steps)
//    added UV info. uv type -> checked:each blades has own uv value, unchecked:all blades share one uv value.
//    change default value.
//  2006-10-14 modified by Hiroto Tsubaki (tg@tres-graficos.jp)
//    added divide/dense center/uv type
//    change script name.

function buildUI(obj){
    obj.setParameter("name","Grassy Knoll+");
    
    obj.addParameterSeparator("Blade");
    
    obj.addParameterBool("underground disabled",0,0,1,true,true);
    obj.addParameterFloat("height",1,0,1000,true,true);
    obj.addParameterFloat("thickness",0.06,0,1000,true,true);
    obj.addParameterInt("steps",5,5,30,true,true);
    obj.addParameterInt("divide",1,1,10,true,true);
    
    obj.addParameterSeparator("Base");
    obj.addParameterInt("blade count",100,1,5000,true,true);
    obj.addParameterFloat("unit radius",1,0,1000,true,true);
    obj.addParameterBool("dense center",1,0,1,true,true);
    obj.addParameterBool("uv type",0,0,1,true,true);
}

function buildObject(obj){
    var core      = obj.core();

    var bx,bz,ba,bd;
    var gr,gsx,gsz,gra,gsxa,gsza;
    var stp,dim,dimb;
    var bxd,bzd;
    
    var i,j,k;

    var x1,y1,z1;
    var x2,y2,z2;
    var x1a,y1a,z1a;
    var x2a,y2a,z2a;
    var x3,y3,z3;
    var x4,y4,z4;
    
    var unitradius = obj.getParameter("unit radius");
    var ug = obj.getParameter("underground disabled");
    var height = obj.getParameter("height") * 3;
    var thickness = obj.getParameter("thickness");
    var steps = obj.getParameter("divide");
    var blades=obj.getParameter("blade count");
    var uvtype = obj.getParameter("uv type");
    var densecenter = obj.getParameter("dense center");
    var uvcount = 0;
    var grcount = obj.getParameter("steps");
    
    core.buildVertexBSP(new Vec3D(-unitradius-1,-height,-unitradius-1) ,new Vec3D(unitradius+1,height,unitradius+1));
    
    stp = Math.ceil(grcount / steps);
    gr_base = height / 20;
    gr_abase = height / 100;

	for (j=0; j < blades; j++) {
        if (densecenter) {
	        ba = Math.random() * 6.282;
		    bd = Math.random() * Math.random() * unitradius;
    		bx = Math.sin(ba) * bd;
    		bz = Math.cos(ba) * bd;
        } else {
            ba = Math.random() * unitradius * 2 - unitradius;
            bd = Math.random() * unitradius * 2 - unitradius;
            bx = ba;
            bz = bd;
        }
   		ba = Math.random() * 6.282;

		gr = Math.random() * gr_base + gr_base/10 + 0.01;
		gsx = Math.random() * gr_abase;
		gsz = Math.random() * gr_abase;
		gra = Math.random() * gr_abase - gr_abase/2;
		gsxa = Math.random() * gr_abase - gr_abase/2;
		gsza = Math.random() * gr_abase - gr_abase/2;
	
		x1 = bx + (Math.sin(ba) * thickness/2);
		y1 = 0;
		z1 = bz + (Math.cos(ba) * thickness/2);

		x2 = bx - (Math.sin(ba) * thickness/2);
		y2 = 0;
		z2 = bz - (Math.cos(ba) * thickness/2);
		
		x1a = x1;
		y1a = y1;
		z1a = z1;
		
		x2a = x2;
		y2a = y2;
		z2a = z2;
        //
        
        uvcount = 0;
        
		for (i=0; i< grcount; i++) {
			x3 = (bx * 0.15) + (x2 * 0.85) + gsx;
			y3 = y2 + gr;
			z3 = (bz * 0.15) + (z2 * 0.85) + gsz;
	
			x4 = (bx * 0.15) + (x1 * 0.85) + gsx;
			y4 = y1 + gr;
			z4 = (bz * 0.15) + (z1 * 0.85) + gsz;

        	if (y3 < 0 && ug) {
        	   break;
        	}
        	
        	if (i%steps == 0) {
    		    var verts = [
        			new Vec3D(x1a,y1a,z1a),
        	 		new Vec3D(x2a,y2a,z2a),
        	 		new Vec3D(x3,y3,z3),
        			new Vec3D(x4,y4,z4)
        					];
        		if (uvtype) {
               	    var uvs = [
            	               new Vec2D(1/blades*(j+1),1-1/stp*uvcount),
            	               new Vec2D(1/blades*j,1-1/stp*uvcount),
            	               new Vec2D(1/blades*j,1-1/stp*(uvcount+1)),
            	               new Vec2D(1/blades*(j+1),1-1/stp*(uvcount+1))
            	               ];
        	    } else {
               	    var uvs = [
            	               new Vec2D(1,1-1/stp*uvcount),
            	               new Vec2D(0,1-1/stp*uvcount),
            	               new Vec2D(0,1-1/stp*(uvcount+1)),
            	               new Vec2D(1,1-1/stp*(uvcount+1))
            	               ];    	    
        	    }
    			core.addPolygon(4,true,verts,uvs);
    			
    			x2a = x3;
    			y2a = y3;
    			z2a = z3;
    
    			x1a = x4;
    			y1a = y4;
    			z1a = z4;
    			
    			uvcount++;
            }
			x2 = x3;
			y2 = y3;
			z2 = z3;

			x1 = x4;
			y1 = y4;
			z1 = z4;
            
			gr += gra;
			gsx += gsxa;
			gsz += gsza;

			gra *= 0.95;
		}
	}
    core.destroyVertexBSP();
}



